﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Activities;
using TravelDataLib;

namespace TravelRequestService
{

  public sealed class TraveRequestQueueAddActivity : CodeActivity
  {
      // Wysyła zgłoszenie podróży do zapisanej w bazie danych kolejki określonego przełożonego.

    public InArgument<TravelRequestMsg> TravelRequest { get; set; }
    public InArgument<string> ManagerId { get; set; }

    protected override void Execute(CodeActivityContext context)
    {
        // Pobieranie zgłoszenia podróży z kontekstu.
      TravelRequestMsg tRequest = context.GetValue(this.TravelRequest);

      // Ustawianie identyfikatora procesu na potrzeby korelowania.
      tRequest.WorkflowInstanceId = context.WorkflowInstanceId.ToString();

      // Konfigurowanie powiadomienia do przełożonego odpowiedzialnego za zatwierdzenie zgłoszenia.
      tRequest.ApprovalManagerId = context.GetValue(this.ManagerId);

      // Zapisywanie zgłoszenia podróży.
      TravelRequestDataAccess.Save(tRequest);
      

    }
  }
}
